csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure S1 - Mussel & oyster calibration curves/CSV/'
figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure S1 - Mussel & oyster calibration curves/'

setwd(csvDirectory)
d = read.csv('Mussel & oyster calibration data.csv')

tiff(filename = 'Figure S1(2).tif', width = 3000, height = 1500, res = 300)
col = alpha(c('red','blue'),0.5)
par(mfrow = c(1,2))
par(mar = c(5,5,3,2))
i = 1

for(i in 1:length(unique(d$species))){
filter = d$species == unique(d$species)[i]

if(i == 1){
plot(d$mass.g[filter] ~ d$length.mm[filter], log = 'yx', 
     ylab = 'Dry mass (g)', xlab = 'Shell length (mm)',
     pch = '.', cex = 2.5, col = col[i], yaxt = 'n',
     main = unique(d$species)[i],
     ylim = c(0.001,1000), xlim = c(2,200))
} else {
  plot(d$mass.g[filter] ~ d$length.mm[filter], log = 'yx', 
       ylab = 'Dry mass (g)', xlab = 'Shell length (mm)',
       pch = '.', cex = 2.5, col = col[i], yaxt = 'n',
       main = unique(d$species)[i],
       ylim = c(0.0001,100), xlim = c(1,100))
}
axis(side = 2, at = 10^seq(-5,5, 1), labels = 10^seq(-5,5, 1))
m = lm(log(d$mass.g[filter]) ~ log(d$length.mm[filter]))
summary(m)
a = exp(m$coefficients[1])
b = m$coefficients[2]
xv = seq(min(d$length.mm[filter]), max(d$length.mm[filter]), length.out = 1000)
yv = a*xv^b
lines(yv ~ xv, col = col[i], lwd = 2)
lines(yv ~ xv, lty = 2)
if(i == 1){
  text(x = 20, y = 500, cex = 0.8,
       paste('Dry mass (g) =', round(a, 6), '* Shell length (mm) ^', round(b,4)))
  text(x = 20, y = 0.002, cex = 0.8,
       expression('(F'[1*','*700] *' = 1.4*10'^4* ', R'^2*' = 0.953, n = 702, p < 0.001)'))
} else {
  text(x = 10, y = 50, cex = 0.8,
       paste('Dry mass (g) =', round(a, 6), '* Shell length (mm) ^', round(b,4)))
  text(x = 10, y = 0.0002, cex = 0.8,
       expression('(F'[1*','*1148] *' = 1.6*10'^5* ', R'^2*' = 0.993, n = 1150, p < 0.001)'))
}



# Calibration
print(summary(m))
print(paste(unique(d$species)[i], ': Dry mass (g) =', round(a, 6), '* Shell length (mm) ^', round(b,4)))
}
par(mfrow = c(1,1))
setwd(figureDirectory)
dev.off()